###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_asterisk_sip_sdp_dos_vuln.nasl 7137 2010-02-05 21:06:24Z feb $
#
# Asterisk T.38 Negotiation Remote Denial Of Service Vulnerability
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800463);
  script_version("$Revision: 6717 $: 1.0");
  script_cve_id("CVE-2010-0441");
  script_bugtraq_id(38047);
  script_name("Asterisk T.38 Negotiation Remote Denial Of Service Vulnerability");
  desc = "
  Overview: This host is running Asterisk and is prone to Denial of Service
  vulnerability.

  Vulnerability Insight:
  The flaw is caused by an error when handling 'T.38 negotiations' over SIP with
  a negative or overly large value in the 'FaxMaxDatagram' field, or without any
  'FaxMaxDatagram' field, which could allows attackers to crash a server.

  Impact:
  Successful exploitation could result in denial of serivce condition.

  Impact Level: Application

  Affected Software/OS:
  Asterisk version 1.6.0.x before 1.6.0.22, 1.6.1.x before 1.6.1.14, and
  1.6.2.x before 1.6.2.2

  Fix: Upgrade to version 1.6.0.22, 1.6.1.14, 1.6.2.2 or apply the patch,
  http://www.asterisk.org/downloads
  http://downloads.asterisk.org/pub/security/AST-2010-001-1.6.0.diff
  http://downloads.asterisk.org/pub/security/AST-2010-001-1.6.1.diff
  http://downloads.asterisk.org/pub/security/AST-2010-001-1.6.2.diff

  *****
  NOTE: Please ignore the warning if the patch is applied.
  *****

  References:
  http://secunia.com/advisories/38395
  http://www.vupen.com/english/advisories/2010/0289
  http://securitytracker.com/alerts/2010/Feb/1023532.html
  http://downloads.asterisk.org/pub/security/AST-2010-001.html

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:P/I:N/A:N)
    CVSS Temporal Score : 3.7
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Asterisk");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2010 Greenbone Networks GmbH");
  script_family("Denial of Service");
  script_dependencies("secpod_asterisk_detect.nasl");
  script_require_keys("Asterisk-PBX/Ver", "Asterisk-PBX/Installed");
  exit(0);
}


include("ssh_func.inc");
include("version_func.inc");

asteriskVer = get_kb_item("Asterisk-PBX/Ver");
if(!asteriskVer)
{
  if(get_kb_item("Asterisk-PBX/Installed"))
  {
    astk_sock = ssh_login_or_reuse_connection();
    if(!astk_sock){
      exit(0);
    }
    paths = find_file(file_name:"asterisk", file_path:"/", useregex:TRUE,
                      regexpar:"$", sock:astk_sock);
    foreach binName (paths)
    {
      asteriskVer = get_bin_version(full_prog_name:chomp(binName), sock:astk_sock,
                                    version_argv:"-V",
                                    ver_pattern:"Asterisk ([0-9.]+(.?[a-z0-9]+)?)");
      asteriskVer[1] = ereg_replace(pattern:"-", replace:".", string:asteriskVer[1]);
      if(asteriskVer[1] != NULL)
        asteriskVer = asteriskVer[1];
    }
    ssh_close_connection();
  }
}

if(version_in_range(version:asteriskVer, test_version:"1.6.2", test_version2:"1.6.2.1")||
   version_in_range(version:asteriskVer, test_version:"1.6.0", test_version2:"1.6.0.21")||
   version_in_range(version:asteriskVer, test_version:"1.6.1", test_version2:"1.6.1.13")){
  security_warning(port:5060, proto:"udp");
}
