###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_avant_browser_addr_bar_spoofing_vuln.nasl 4378 2009-09-02 11:59:29Z sep $
#
# Avant Browser Address Bar Spoofing Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800871);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-3004");
  script_name("Avant Browser Address Bar Spoofing Vulnerability");
  desc = "
  Overview: This host is installed with Avant Browser and is prone to Address
  Bar Spoofing vulnerability.

  Vulnerability Insight:
  Address bar can be spoofed via 'window.open()' with a relative URI, to
  show an arbitrary URL on the web site visited by the victim, as demonstrated
  by a visit to an attacker-controlled web page, which triggers a spoofed login
  form for the site containing that page.

  Impact:
  Successful exploitation lets the attackers to spoof parts of the address bar
  and modify page content on a host that a user may consider partly trusted.

  Impact Level: Application

  Affected Software/OS:
  Avant Browser version 11.7 Build 35 and 36 on Windows.

  Fix: No solution or patch is available as on 2nd September 2009, Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.avantbrowser.com/

  References:
  http://lostmon.blogspot.com/2009/08/multiple-browsers-fake-url-folder-file.html

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:N/I:P/A:N)
    CVSS Temporal Score : 3.9
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Avant Browser");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("General");
  script_dependencies("gb_avant_browser_detect.nasl");
  script_require_keys("AvantBrowser/Ver");
  exit(0);
}


include("version_func.inc");

abVer = get_kb_item("AvantBrowser/Ver");
if(!abVer){
  exit(0);
}

# Check for Avant Browser version 11.7 Build 35 and 36
if(version_is_equal(version:abVer, test_version:"11.7.0.35")||
   version_is_equal(version:abVer, test_version:"11.7.0.36")){
  security_warning(0);
}
