###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_baofeng_storm_detect.nasl 3686 2009-08-01 16:12:28Z aug $
#
# BaoFeng Storm Version Detection
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800913);
  script_version("$Revision: 1.0$");
  script_name("BaoFeng Storm Version Detection");
  desc = "
  Overview : This script finds the installed BaoFeng Storm
  version and saves the version in KB.

  Risk factor : Informational";

  script_description(desc);
  script_summary("Set version of BaoFeng Storm in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\Storm2";
stormPath = registry_get_sz(key:key, item:"DisplayIcon");

if("Storm" >< stormPath)
{
  stormVer =  registry_get_sz(key:key, item:"DisplayVersion");
  if(stormVer != NULL){
    set_kb_item(name:"BaoFeng/Storm/Ver", value:stormVer);
  }
}
