###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_becky_internet_mail_detect.nasl 1031 2009-02-18 10:27:50Z feb $
#
# Becky Internet Mail Version Detection
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800518);
  script_version("$Revision: 1.0 $");
  script_name("Becky Internet Mail Version Detection");
  desc = "

  Overview: This script detects the version of Becky Internet Mail and
  sets the result in KB.

  Risk factor: Informational";

  script_description(desc);
  script_summary("Check for the Version of Becky Internet Mail");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("General");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";

if(!registry_key_exists(key:key)){
    exit(0);
}

foreach item (registry_enum_keys(key:key))
{
  if("Becky!" >< registry_get_sz(key:key + item, item:"DisplayName"))
  {
    path = registry_get_sz(key:key + item, item:"DisplayIcon");
    if(path != NULL)
    {
      bimPath = ereg_replace(pattern:'\"(.*)\".*', replace:"\1", string:path);
      share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:bimPath);
      file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:bimPath);
      bimVer = GetVer(share:share, file:file);
      if(bimVer){
        set_kb_item(name:"Becky/InternetMail/Ver", value: bimVer);
      }
    }
    exit(0);
  }
}
