###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_ca_etrust_scm_mult_vuln.nasl 0280 2008-09-24 12:42:42Z sep $
#
# CA eTrust SCM Multiple HTTP Gateway Service Vulnerabilities
#
# Authors:
# Veerendra GG <veerendragg@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800101);
  script_version("$Revision: 1.1 $");
  script_cve_id("CVE-2008-2541");
  script_bugtraq_id(29528);
  script_xref(name:"CB-A", value:"08-0091");
  script_name("CA eTrust SCM Multiple HTTP Gateway Service Vulnerabilities");
  desc = "

  Overview : The host is installed with CA eTrust Secure Content Manager which
  is prone to arbitrary code execution and DoS Vulnerabilities.

  Vulnerability Insight:
  The flaws are caused due to,
  - boundary error in the HTTP Gateway service (icihttp.exe running on
    port 8080), when converting content of an FTP request listing from raw
    text to HTML.
  - insufficient bounds checking on certain FTP requests by sending a specially
    crafted FTP requests containing an overly long LIST/PASV commands that can
    cause stack-based buffer overflow.

  Impact:
  Successful exploitation allow attackers to execute arbitrary code or
  compromise complete system under the system context or denying of service.

  Impact Level : System

  Affected Software/OS:
  CA eTrust Secure Content Manager version 8.0 - Windows (Any).

  Fix : Apply patch QO99987,
  https://support.ca.com/irj/portal/ano...s?reqPage=search&searchID=QO99987

  *****
  NOTE : Ignore this warning, if above mentioned patch is applied already.
  *****

  References:
  http://secunia.com/advisories/30518
  http://www.zerodayinitiative.com/advisories/ZDI-08-035/
  http://www.zerodayinitiative.com/advisories/ZDI-08-036/
  http://www.ca.com/us/securityadvisor/vulninfo/vuln.aspx?id=36408

  CVSS Score:
    CVSS Base Score     : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 5.5
  Risk factor : High";

  script_description(desc);
  script_summary("Check for the version of CA eTrust SCM");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports("Services/www", 8080);
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");

if(!get_kb_item("SMB/WindowsVersion")){ # Confirm it is Windows
  exit(0);
}

port = 8080;
if(!get_port_state(port)){ # Confirm port is open (8080)
  exit(0);
}

# Confirm SCM is installed
if(!registry_key_exists(key:"SOFTWARE\ComputerAssociates\eTrust\SCM")){
  exit(0);
}

# Get CA SCM Version
scmVer = registry_get_sz(item:"Version",
                  key:"SOFTWARE\ComputerAssociates\eTrust Common Services");
if(!scmVer){
  exit(0);
}

# Grep for CSM version <= 8.0.28
if(egrep(pattern:"^([0-7]\..*|8\.0\.([01]?[0-9]|2[0-8]))$", string:scmVer)){
  security_hole(port);
}
