###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_cpcreator_sql_inj_vuln.nasl 4962 2009-10-05 15:11:27Z oct $
#
# cP Creator 'tickets' Cookie SQL Injection Vulnerability
#
# Authors:
# Antu Sanadi<santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(801006);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-3330");
  script_name("cP Creator 'tickets' Cookie SQL Injection Vulnerability");
  desc ="
  Overview: The host is running cP Creator and is prone to SQL Injection
  Vulnerability

  Vulnerability Insight:
  Input passed to the 'tickets' cookie in index.php (if 'page' is set to
  'support' and 'task' is set to 'ticket') is not properly sanitised before
  being used in SQL queries.

  Impact:
  Successful exploitation could allow remote attackers to conduct SQL injection
  attacks.

  Impact Level: Application.

  Affected Software/OS:
  cP Creator Version 2.7.1 and prior.

  Fix:
  No solution or patch is available as on 05th October, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.cpcreator.com/download.php

  References:
  http://secunia.com/advisories/36815
  http://www.milw0rm.com/exploits/9726

  CVSS Score:
   CVSS Base Score      : 6.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:P)
   CVSS Temporal Score  : 6.1
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version cP Creator");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) Intevation GmbH");
  script_dependencies("gb_cpcreator_detect.nasl");
  script_family("Web application abuses");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

cpcreatPort = get_http_port(default:80);
if(!cpcreatPort){
  exit(0);
}

cpcreatVer = get_kb_item("www/" + cpcreatPort + "/cPCreator");
if(!cpcreatVer){
  exit(0);
}

cpcreatVer = eregmatch(pattern:"^(.+) under (/.*)$", string:cpcreatVer);
if(cpcreatVer[1] != NULL)
{
  if(version_is_less_equal(version:cpcreatVer[1], test_version:"2.7.1")){
    security_hole(cpcreatPort);
  }
}
