###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_dokuwiki_detect.nasl 2746 2009-06-17 13:52:24Z jun $
#
# DokuWiki Version Detection
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Updated By: Rachana Shetty <srachana@secpod.com> on 2010-02-18
# Update to consider the bodyonly for responses
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800587);
  script_version("Revision: 1.1 ");
  script_name("DokuWiki Version Detection");
  desc = "
  Overview: This script detects the installed version of DokuWiki and
  sets the version in KB.

  Risk factor: Informational";

  script_description(desc);
  script_summary("Sets the KB for the version of DokuWiki");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");

dokuwikiPort = get_http_port(default:80);
if(!dokuwikiPort){
  dokuwikiPort = 80;
}

if(!get_port_state(dokuwikiPort)){
  exit(0);
}

foreach dir (make_list("/dokuwiki", cgi_dirs()))
{
  sndReq = http_get(item:string(dir + "/VERSION"), port:dokuwikiPort);
  rcvRes = http_keepalive_send_recv(port:dokuwikiPort, data:sndReq, bodyonly:1);
  if (rcvRes != NULL)
  {
    dokuwikiVer = eregmatch(pattern:"(rc)?([0-9]+\-[0-9]+\-[0-9]+[a-z]?)",
                            string:rcvRes);
    dokuVer = ereg_replace(pattern:"-", string:dokuwikiVer[2], replace: ".");
    if(dokuVer)
    {
      set_kb_item(name:"www/" + dokuwikiPort + "/DokuWiki",
                  value:dokuVer + " under " + dir);
    }
  }
}
