##############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_dotnetnuke_detect.nasl 4349 2009-09-02 16:04:29Z sep $
#
# DotNetNuke Version Detection
#
# Authors:
# Antu Sanadi<santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
################################################################################

if(description)
{
  script_id(800683);
  script_version("$Revision: 1.0$");
  script_name("DotNetNuke Version Detection");
  desc = "
  Overview: This script detects the installed version of DotNetNuke and sets the
  result in KB.

  Risk factor: Informational";

  script_description(desc);
  script_summary("Set KB for the version of DotNetNuke");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");

dnnPort = get_http_port(default:80);
if(!dnnPort){
  dnnPort = 80;
}

if(!get_port_state(dnnPort)){
  exit(0);
}

foreach dir (make_list("/DotNetNuke","/DotNetNuke Website", "/", cgi_dirs()))
{
  sndReq = http_get(item:string(dir, "/default.aspx"), port:dnnPort);
  rcvRes = http_send_recv(port:dnnPort, data:sndReq);
  if("DotNetNuke" >< rcvRes)
  {
    dnnver = eregmatch(pattern:"DNN ([0-9.]+)", string:rcvRes);
    if(dnnVer[1] != NULL)
    {
      set_kb_item(name:"www/"+ dnnPort + "/DotNetNuke",
                  value:dnnVer[1] + " under " + dir);
    }
  }
}
