###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_elecard_mpeg_player_detect.nasl 1001 2009-02-11 90:07:05Z feb $
#
# Elecard MPEG Player Application Version Detection
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800510);
  script_version("$Revision: 1.0 $");
  script_name("Elecard MPEG Player Application Version Detection");
  desc = "
  Overview: This script detects the installed version of Elecard MPEG
  Player application and sets the version in KB.

  Risk factor: Informational";

  script_description(desc);
  script_summary("Sets KB for the version of Elecard MPEG Player");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("General");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

if(!registry_key_exists(key:"SOFTWARE\Elecard")){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";
keys = registry_enum_keys(key:key);

foreach item(keys)
{
  appName = registry_get_sz(key:key + item, item:"DisplayName");
  if(appName == "Elecard MPEG Player")
  {
    path = registry_get_sz(key:key + item, item:"InstallLocation");
    share = ereg_replace(pattern:"([A-Z]):.*",replace:"\1$",string:path);
    file = ereg_replace(pattern:"[A-Z]:(.*)",replace:"\1",string:path+ "\MpegPlayer.exe");
  }
}

name = kb_smb_name();
domain = kb_smb_domain();
login = kb_smb_login();
pass = kb_smb_password();
port = kb_smb_transport();

soc = open_sock_tcp(port);
if(!soc){
  exit(0);
}

r = smb_session_request(soc:soc, remote:name);
if(!r)
{
  close(soc);
  exit(0);
}

prot = smb_neg_prot(soc:soc);
if(!prot)
{
  close(soc);
  exit(0);
}

r = smb_session_setup(soc:soc, login:login, password:pass,
                      domain:domain, prot:prot);
if(!r)
{
  close(soc);
  exit(0);
}

uid = session_extract_uid(reply:r);
r = smb_tconx(soc:soc, name:name, uid:uid, share:share);

tid = tconx_extract_tid(reply:r);
if(!tid)
{
  close(soc);
  exit(0);
}

fid = OpenAndX(socket:soc, uid:uid, tid:tid, file:file);
if(!fid)
{
  close(soc);
  exit(0);
}

eleVer = GetVersion(socket:soc, uid:uid, tid:tid, fid:fid, offset:1067429);
close(soc);
if(eleVer != NULL)
{
  set_kb_item(name:"Elecard/Player/Ver", value:eleVer);
  exit(0);
}
