##############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_eureka_email_detect.nasl 5593 2009-11-05 14:30:24Z nov $
#
# Eureka Email Version Detection
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(801040);
  script_version("$Revision: 1.0 $");
  script_name("Eureka Email Version Detection");
  desc = "
  Overview: This script detects the installed version of Eureka Email and
  sets the result in KB.

  Risk factor: Informational";

  script_description(desc);
  script_summary("Set version of Eureka Email in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";

if(!registry_key_exists(key:key)){
   exit(0);
}

foreach item (registry_enum_keys(key:key))
{
  eeName = registry_get_sz(key:key + item, item:"DisplayName");
  if("Eureka Email" >< eeName)
  {
    eePath = registry_get_sz(key:key + item, item:"Inno Setup: App Path");
    if(eePath)
    {
      eePath += "\Eureka Email.EXE";
      share = ereg_replace(pattern:"([A-Za-z]):.*", replace:"\1$", string:eePath);
      file =  ereg_replace(pattern:"[A-Za-z]:(.*)", replace:"\1", string:eePath);

      eeVer = GetVer(file:file, share:share);
      if(eeVer != NULL){
        set_kb_item(name:"EurekaEmail/Ver", value:eeVer);
      }
    }
  }
}
