###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_f3site_mult_lfi_vuln.nasl 6443 2010-01-13 15:11:27Z jan $
#
# F3Site 'GLOBALS[nlang]' Parameter Multiple Local File Include Vulnerabilities
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800415);
  script_version("$Revision: 6399 $: 1.0");
  script_cve_id("CVE-2009-4435");
  script_bugtraq_id(37408);
  script_name("F3Site 'GLOBALS[nlang]' Parameter Multiple Local File Include Vulnerabilities");
  desc = "
  Overview: The host is running F3Site and is prone to multiple local file include
  Vulnerabilities.

  Vulnerability Insight:
  The flaw is caused due to error in 'mod/poll.php' and 'mod/new.php' which
  are not properly sanitising user supplied input data via 'GLOBALS[nlang]'
  parameter.

  Impact:
  Successful exploitation could allow remote attackers to obtain sensitive
  information or execute arbitrary code on the vulnerable Web Server.

  Impact Level: Application.

  Affected Software/OS:
  F3Site 2009 and prior.

  Fix:
  No solution or patch is available as on 13th january, 2010 Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://dhost.info/compmaster/index.php

  References:
  http://xforce.iss.net/xforce/xfdb/54908
  http://www.exploit-db.com/exploits/10536

  CVSS Score:
    CVSS Base Score      : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score  : 6.7
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of F3Site");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_dependencies("find_service.nes");
  script_family("Web application abuses");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

f3sPort = get_http_port(default:80);
if(!f3sPort){
  exit(0);
}

foreach path (make_list("/", "/F3Site/SYSTEM", "/F3Site", cgi_dirs()))
{
  sndReq = http_get(item:string(path, "/index.php"), port:f3sPort);
  rcvRes = http_send_recv(port:f3sPort, data:sndReq);
  if("F3Site" >< rcvRes)
  {
    f3sVer = eregmatch(pattern:"F3Site ([0-9.]+)",string:rcvRes);
    if(f3sVer[1] != NULL)
    {
      if(version_is_less_equal(version:f3sVer[1], test_version:"2009")){
        security_hole(f3sPort);
      }
    }
  }
}

