###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for php-pear-DB FEDORA-2007-0249
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861270);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2007-0249");
  script_cve_id("CVE-2006-2313", "CVE-2006-2314");
  script_name( "Fedora Update for php-pear-DB FEDORA-2007-0249");
  desc = "

  Vulnerability Insight:
  DB is a database abstraction layer providing:
  * an OO-style query API
  * portability features that make programs written for one DBMS work with
    other DBMS's
  * a DSN (data source name) format for specifying database servers
  * prepare/execute (bind) emulation for databases that don't support it natively
  * a result object for each query response
  * portable error codes
  * sequence emulation
  * sequential and non-sequential row fetching as well as bulk fetching
  * formats fetched rows as associative arrays, ordered arrays or objects
  * row limit support
  * transactions support
  * table information interface
  * DocBook and phpDocumentor API documentation
  
  DB layers itself on top of PHP's existing database extensions.


  Affected Software/OS:
  php-pear-DB on Fedora 7

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-June/msg00055.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of php-pear-DB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC7")
{

  if(isrpmvuln(pkg:"php-pear-DB", rpm:"php-pear-DB~1.7.11~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php-pear-DB", rpm:"php-pear-DB~1.7.11~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}