###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for spamassassin FEDORA-2007-0390
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861034);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2007-0390");
  script_cve_id("CVE-2007-2873");
  script_name( "Fedora Update for spamassassin FEDORA-2007-0390");
  desc = "

  Vulnerability Insight:
  SpamAssassin provides you with a way to reduce if not completely eliminate
  Unsolicited Commercial Email (SPAM) from your incoming email.  It can
  be invoked by a MDA such as sendmail or postfix, or can be called from
  a procmail script, .forward file, etc.  It uses a genetic-algorithm
  evolved scoring system to identify messages which look spammy, then
  adds headers to the message so they can be filtered by the user's mail
  reading software.  This distribution includes the spamd/spamc components
  which create a server that considerably speeds processing of mail.
  
  To enable spamassassin, if you are receiving mail locally, simply add
  this line to your ~/.procmailrc:
  INCLUDERC=/etc/mail/spamassassin/spamassassin-default.rc
  
  To filter spam for all users, add that line to /etc/procmailrc
  (creating if necessary).


  Affected Software/OS:
  spamassassin on Fedora 7

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-June/msg00211.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of spamassassin");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC7")
{

  if(isrpmvuln(pkg:"spamassassin", rpm:"spamassassin~3.2.1~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"spamassassin", rpm:"spamassassin~3.2.1~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"spamassassin-debuginfo", rpm:"spamassassin-debuginfo~3.2.1~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"spamassassin", rpm:"spamassassin~3.2.1~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"spamassassin-debuginfo", rpm:"spamassassin-debuginfo~3.2.1~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}