###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for w3m FEDORA-2007-077
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861184);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2007-077");
  script_cve_id("");
  script_name( "Fedora Update for w3m FEDORA-2007-077");
  desc = "

  Vulnerability Insight:
  The w3m program is a pager (or text file viewer) that can also be used
  as a text-mode Web browser. W3m features include the following: when
  reading an HTML document, you can follow links and view images using
  an external image viewer; its internet message mode determines the
  type of document from the header; if the Content-Type field of the
  document is text/html, the document is displayed as an HTML document;
  you can change a URL description like '<a  rel= &qt nofollow &qt  href= &qt http://hogege.net &qt >http://hogege.net</a>' in plain
  text into a link to that URL.
  If you want to display the inline images on w3m, you need to install
  w3m-img package as well.


  Affected Software/OS:
  w3m on Fedora Core 6

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-January/msg00082.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of w3m");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC6")
{

  if(isrpmvuln(pkg:"w3m", rpm:"w3m~0.5.1~15.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/w3m-img", rpm:"x86_64/w3m-img~0.5.1~15.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/debug/w3m-debuginfo", rpm:"x86_64/debug/w3m-debuginfo~0.5.1~15.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/w3m", rpm:"x86_64/w3m~0.5.1~15.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/debug/w3m-debuginfo", rpm:"i386/debug/w3m-debuginfo~0.5.1~15.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/w3m-img", rpm:"i386/w3m-img~0.5.1~15.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/w3m", rpm:"i386/w3m~0.5.1~15.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}