###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for libsoup FEDORA-2007-109
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861548);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2007-109");
  script_cve_id("");
  script_name( "Fedora Update for libsoup FEDORA-2007-109");
  desc = "

  Vulnerability Insight:
  Libsoup is an HTTP library implementation in C. It was originally part
  of a SOAP (Simple Object Access Protocol) implementation called Soup, but
  the SOAP and non-SOAP parts have now been split into separate packages.
  
  libsoup uses the Glib main loop and is designed to work well with GTK
  applications. This enables GNOME applications to access HTTP servers
  on the network in a completely asynchronous fashion, very similar to
  the Gtk+ programming model (a synchronous operation mode is also
  supported for those who want it).


  Affected Software/OS:
  libsoup on Fedora Core 6

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-January/msg00155.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of libsoup");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC6")
{

  if(isrpmvuln(pkg:"libsoup", rpm:"libsoup~2.2.99~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/debug/libsoup-debuginfo", rpm:"x86_64/debug/libsoup-debuginfo~2.2.99~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/libsoup", rpm:"x86_64/libsoup~2.2.99~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/libsoup-devel", rpm:"x86_64/libsoup-devel~2.2.99~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/libsoup-devel", rpm:"i386/libsoup-devel~2.2.99~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/libsoup", rpm:"i386/libsoup~2.2.99~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/debug/libsoup-debuginfo", rpm:"i386/debug/libsoup-debuginfo~2.2.99~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}