###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for python FEDORA-2007-2663
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861387);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2007-2663");
  script_cve_id("CVE-2007-4965");
  script_name( "Fedora Update for python FEDORA-2007-2663");
  desc = "

  Vulnerability Insight:
  Python is an interpreted, interactive, object-oriented programming
  language often compared to Tcl, Perl, Scheme or Java. Python includes
  modules, classes, exceptions, very high level dynamic data types and
  dynamic typing. Python supports interfaces to many system calls and
  libraries, as well as to various windowing systems (X11, Motif, Tk,
  Mac and MFC).
  
  Programmers can write new built-in modules for Python in C or C++.
  Python can be used as an extension language for applications that need
  a programmable interface. This package contains most of the standard
  Python modules, as well as modules for interfacing to the Tix widget
  set for Tk and RPM.
  
  Note that documentation for Python is provided in the python-docs
  package.


  Affected Software/OS:
  python on Fedora 7

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-October/msg00378.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of python");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC7")
{

  if(isrpmvuln(pkg:"python", rpm:"python~2.5~14.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tkinter", rpm:"tkinter~2.5~14.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"python-debuginfo", rpm:"python-debuginfo~2.5~14.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"python", rpm:"python~2.5~14.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"python-devel", rpm:"python-devel~2.5~14.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"python-libs", rpm:"python-libs~2.5~14.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"python-tools", rpm:"python-tools~2.5~14.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tkinter", rpm:"tkinter~2.5~14.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"python", rpm:"python~2.5~14.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"python-debuginfo", rpm:"python-debuginfo~2.5~14.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"python-devel", rpm:"python-devel~2.5~14.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"python-libs", rpm:"python-libs~2.5~14.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"python-tools", rpm:"python-tools~2.5~14.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}