###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for kde-i18n FEDORA-2007-2985
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861064);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2007-2985");
  script_cve_id("CVE-2007-4352", "CVE-2007-5392", "CVE-2007-5393");
  script_name( "Fedora Update for kde-i18n FEDORA-2007-2985");
  desc = "

  Vulnerability Insight:
  Internationalization support for KDE


  Affected Software/OS:
  kde-i18n on Fedora 7

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-November/msg00310.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of kde-i18n");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC7")
{

  if(isrpmvuln(pkg:"kde-i18n", rpm:"kde-i18n~3.5.8~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kde-i18n-Slovak", rpm:"kde-i18n-Slovak~3.5.8~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kde-i18n-German", rpm:"kde-i18n-German~3.5.8~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kde-i18n-Portuguese", rpm:"kde-i18n-Portuguese~3.5.8~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kde-i18n-Tamil", rpm:"kde-i18n-Tamil~3.5.8~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kde-i18n-Icelandic", rpm:"kde-i18n-Icelandic~3.5.8~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kde-i18n-Finnish", rpm:"kde-i18n-Finnish~3.5.8~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kde-i18n-Norwegian", rpm:"kde-i18n-Norwegian~3.5.8~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kde-i18n-Italian", rpm:"kde-i18n-Italian~3.5.8~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kde-i18n-Bulgarian", rpm:"kde-i18n-Bulgarian~3.5.8~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kde-i18n-Chinese-Big5", rpm:"kde-i18n-Chinese-Big5~3.5.8~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kde-i18n-Polish", rpm:"kde-i18n-Polish~3.5.8~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kde-i18n-Lithuanian", rpm:"kde-i18n-Lithuanian~3.5.8~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kde-i18n-Romanian", rpm:"kde-i18n-Romanian~3.5.8~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kde-i18n-Brazil", rpm:"kde-i18n-Brazil~3.5.8~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kde-i18n-Czech", rpm:"kde-i18n-Czech~3.5.8~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kde-i18n-Danish", rpm:"kde-i18n-Danish~3.5.8~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kde-i18n-Norwegian-Nynorsk", rpm:"kde-i18n-Norwegian-Nynorsk~3.5.8~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kde-i18n-Punjabi", rpm:"kde-i18n-Punjabi~3.5.8~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kde-i18n-Hindi", rpm:"kde-i18n-Hindi~3.5.8~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kde-i18n-Catalan", rpm:"kde-i18n-Catalan~3.5.8~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kde-i18n-British", rpm:"kde-i18n-British~3.5.8~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kde-i18n-Ukrainian", rpm:"kde-i18n-Ukrainian~3.5.8~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kde-i18n-Spanish", rpm:"kde-i18n-Spanish~3.5.8~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kde-i18n-Bengali", rpm:"kde-i18n-Bengali~3.5.8~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kde-i18n-Hebrew", rpm:"kde-i18n-Hebrew~3.5.8~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kde-i18n-Arabic", rpm:"kde-i18n-Arabic~3.5.8~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kde-i18n-Chinese", rpm:"kde-i18n-Chinese~3.5.8~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kde-i18n-Korean", rpm:"kde-i18n-Korean~3.5.8~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kde-i18n-Dutch", rpm:"kde-i18n-Dutch~3.5.8~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kde-i18n-Serbian", rpm:"kde-i18n-Serbian~3.5.8~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kde-i18n-Hungarian", rpm:"kde-i18n-Hungarian~3.5.8~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kde-i18n-Japanese", rpm:"kde-i18n-Japanese~3.5.8~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kde-i18n-Estonian", rpm:"kde-i18n-Estonian~3.5.8~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kde-i18n-Russian", rpm:"kde-i18n-Russian~3.5.8~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kde-i18n-French", rpm:"kde-i18n-French~3.5.8~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kde-i18n-Swedish", rpm:"kde-i18n-Swedish~3.5.8~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kde-i18n-Greek", rpm:"kde-i18n-Greek~3.5.8~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kde-i18n-Slovenian", rpm:"kde-i18n-Slovenian~3.5.8~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kde-i18n-Turkish", rpm:"kde-i18n-Turkish~3.5.8~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}