###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for kernel FEDORA-2007-433
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861186);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2007-433");
  script_cve_id("CVE-2007-1357", "CVE-2007-0005", "CVE-2007-0772", "CVE-2007-0006", "CVE-2006-5757");
  script_name( "Fedora Update for kernel FEDORA-2007-433");
  desc = "

  Vulnerability Insight:
  The kernel package contains the Linux kernel (vmlinuz), the core of any
  Linux operating system.  The kernel handles the basic functions
  of the operating system:  memory allocation, process allocation, device
  input and output, etc.


  Affected Software/OS:
  kernel on Fedora Core 5

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-April/msg00038.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of kernel");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC5")
{

  if(isrpmvuln(pkg:"kernel", rpm:"kernel~2.6.20~1.2312.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ppc/kernel-doc", rpm:"ppc/kernel-doc~2.6.20~1.2312.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/kernel-xen0", rpm:"x86_64/kernel-xen0~2.6.20~1.2312.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/kernel", rpm:"x86_64/kernel~2.6.20~1.2312.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/kernel-xenU-devel", rpm:"x86_64/kernel-xenU-devel~2.6.20~1.2312.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/kernel-debug", rpm:"x86_64/kernel-debug~2.6.20~1.2312.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/kernel-xenU", rpm:"x86_64/kernel-xenU~2.6.20~1.2312.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/kernel-kdump", rpm:"x86_64/kernel-kdump~2.6.20~1.2312.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/kernel-devel", rpm:"x86_64/kernel-devel~2.6.20~1.2312.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/kernel-xen0-devel", rpm:"x86_64/kernel-xen0-devel~2.6.20~1.2312.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/kernel-kdump-devel", rpm:"x86_64/kernel-kdump-devel~2.6.20~1.2312.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/kernel-xen-devel", rpm:"x86_64/kernel-xen-devel~2.6.20~1.2312.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/debug/kernel-debuginfo", rpm:"x86_64/debug/kernel-debuginfo~2.6.20~1.2312.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/kernel-debug-devel", rpm:"x86_64/kernel-debug-devel~2.6.20~1.2312.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/kernel-xen", rpm:"x86_64/kernel-xen~2.6.20~1.2312.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/kernel-doc", rpm:"x86_64/kernel-doc~2.6.20~1.2312.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/debug/kernel-debuginfo", rpm:"i386/debug/kernel-debuginfo~2.6.20~1.2312.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/kernel-smp-devel", rpm:"i386/kernel-smp-devel~2.6.20~1.2312.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/kernel", rpm:"i386/kernel~2.6.20~1.2312.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/debug/kernel-debuginfo", rpm:"i386/debug/kernel-debuginfo~2.6.20~1.2312.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/kernel-devel", rpm:"i386/kernel-devel~2.6.20~1.2312.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/kernel-smp", rpm:"i386/kernel-smp~2.6.20~1.2312.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/kernel-doc", rpm:"i386/kernel-doc~2.6.20~1.2312.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}