###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for e2fsprogs FEDORA-2007-4461
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(860271);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2007-4461");
  script_cve_id("CVE-2007-5497");
  script_name( "Fedora Update for e2fsprogs FEDORA-2007-4461");
  desc = "

  Vulnerability Insight:
  The e2fsprogs package contains a number of utilities for creating,
  checking, modifying, and correcting any inconsistencies in second
  and third extended (ext2/ext3) filesystems. E2fsprogs contains
  e2fsck (used to repair filesystem inconsistencies after an unclean
  shutdown), mke2fs (used to initialize a partition to contain an
  empty ext2 filesystem), debugfs (used to examine the internal
  structure of a filesystem, to manually repair a corrupted
  filesystem, or to create test cases for e2fsck), tune2fs (used to
  modify filesystem parameters), and most of the other core ext2fs
  filesystem utilities.
  
  You should install the e2fsprogs package if you need to manage the
  performance of an ext2 and/or ext3 filesystem.


  Affected Software/OS:
  e2fsprogs on Fedora 7

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2008-January/msg00629.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of e2fsprogs");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC7")
{

  if(isrpmvuln(pkg:"e2fsprogs", rpm:"e2fsprogs~1.40.2~3.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"e2fsprogs-libs", rpm:"e2fsprogs-libs~1.40.2~3.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"e2fsprogs-debuginfo", rpm:"e2fsprogs-debuginfo~1.40.2~3.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"e2fsprogs", rpm:"e2fsprogs~1.40.2~3.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"e2fsprogs-devel", rpm:"e2fsprogs-devel~1.40.2~3.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"e2fsprogs", rpm:"e2fsprogs~1.40.2~3.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"e2fsprogs-libs", rpm:"e2fsprogs-libs~1.40.2~3.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"e2fsprogs-devel", rpm:"e2fsprogs-devel~1.40.2~3.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"e2fsprogs-debuginfo", rpm:"e2fsprogs-debuginfo~1.40.2~3.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}