###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for php FEDORA-2007-503
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861349);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2007-503");
  script_cve_id("CVE-2007-1864", "CVE-2007-2509", "CVE-2007-2510");
  script_name( "Fedora Update for php FEDORA-2007-503");
  desc = "

  Vulnerability Insight:
  PHP is an HTML-embedded scripting language. PHP attempts to make it
  easy for developers to write dynamically generated webpages. PHP also
  offers built-in database integration for several commercial and
  non-commercial database management systems, so writing a
  database-enabled webpage with PHP is fairly simple. The most common
  use of PHP coding is probably as a replacement for CGI scripts.
  
  The php package contains the module which adds support for the PHP
  language to Apache HTTP Server.


  Affected Software/OS:
  php on Fedora Core 6

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-May/msg00022.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of php");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC6")
{

  if(isrpmvuln(pkg:"php", rpm:"php~5.1.6~3.6.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/php-mysql", rpm:"x86_64/php-mysql~5.1.6~3.6.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/php-pdo", rpm:"x86_64/php-pdo~5.1.6~3.6.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/php-imap", rpm:"x86_64/php-imap~5.1.6~3.6.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/php-devel", rpm:"x86_64/php-devel~5.1.6~3.6.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/php-pgsql", rpm:"x86_64/php-pgsql~5.1.6~3.6.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/php-odbc", rpm:"x86_64/php-odbc~5.1.6~3.6.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/debug/php-debuginfo", rpm:"x86_64/debug/php-debuginfo~5.1.6~3.6.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/php-gd", rpm:"x86_64/php-gd~5.1.6~3.6.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/php-soap", rpm:"x86_64/php-soap~5.1.6~3.6.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/php-cli", rpm:"x86_64/php-cli~5.1.6~3.6.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/php-dba", rpm:"x86_64/php-dba~5.1.6~3.6.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/php-bcmath", rpm:"x86_64/php-bcmath~5.1.6~3.6.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/php-xmlrpc", rpm:"x86_64/php-xmlrpc~5.1.6~3.6.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/php-ncurses", rpm:"x86_64/php-ncurses~5.1.6~3.6.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/php-snmp", rpm:"x86_64/php-snmp~5.1.6~3.6.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/php-ldap", rpm:"x86_64/php-ldap~5.1.6~3.6.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/php-mbstring", rpm:"x86_64/php-mbstring~5.1.6~3.6.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/php-common", rpm:"x86_64/php-common~5.1.6~3.6.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/php", rpm:"x86_64/php~5.1.6~3.6.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/php-xml", rpm:"x86_64/php-xml~5.1.6~3.6.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/php-imap", rpm:"i386/php-imap~5.1.6~3.6.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/php-snmp", rpm:"i386/php-snmp~5.1.6~3.6.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/php-common", rpm:"i386/php-common~5.1.6~3.6.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/php-xmlrpc", rpm:"i386/php-xmlrpc~5.1.6~3.6.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/php-xml", rpm:"i386/php-xml~5.1.6~3.6.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/php-mysql", rpm:"i386/php-mysql~5.1.6~3.6.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/php-dba", rpm:"i386/php-dba~5.1.6~3.6.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/php-ncurses", rpm:"i386/php-ncurses~5.1.6~3.6.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/php-gd", rpm:"i386/php-gd~5.1.6~3.6.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/php-devel", rpm:"i386/php-devel~5.1.6~3.6.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/php", rpm:"i386/php~5.1.6~3.6.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/php-mbstring", rpm:"i386/php-mbstring~5.1.6~3.6.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/php-odbc", rpm:"i386/php-odbc~5.1.6~3.6.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/php-pgsql", rpm:"i386/php-pgsql~5.1.6~3.6.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/php-cli", rpm:"i386/php-cli~5.1.6~3.6.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/php-bcmath", rpm:"i386/php-bcmath~5.1.6~3.6.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/php-pdo", rpm:"i386/php-pdo~5.1.6~3.6.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/debug/php-debuginfo", rpm:"i386/debug/php-debuginfo~5.1.6~3.6.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/php-ldap", rpm:"i386/php-ldap~5.1.6~3.6.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/php-soap", rpm:"i386/php-soap~5.1.6~3.6.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}