###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for xorg-x11-xinit FEDORA-2007-659
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861042);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2007-659");
  script_cve_id("CVE-2006-5214");
  script_name( "Fedora Update for xorg-x11-xinit FEDORA-2007-659");
  desc = "

  Vulnerability Insight:
  X.Org X11 X Window System xinit startup scripts
  
  ---------------------------------------------------------------------
  
  * Thu Aug  2 2007 Soren Sandmann &lt;sandmann redhat com&gt; - 1.0.2-16
  - Fix bug 212167; CVE-2006-5214


  Affected Software/OS:
  xorg-x11-xinit on Fedora Core 6

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-August/msg00130.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of xorg-x11-xinit");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC6")
{

  if(isrpmvuln(pkg:"xorg-x11-xinit", rpm:"xorg-x11-xinit~1.0.2~16.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/debug/xorg-x11-xinit-debuginfo", rpm:"x86_64/debug/xorg-x11-xinit-debuginfo~1.0.2~16.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/xorg-x11-xinit", rpm:"x86_64/xorg-x11-xinit~1.0.2~16.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/xorg-x11-xinit", rpm:"i386/xorg-x11-xinit~1.0.2~16.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/debug/xorg-x11-xinit-debuginfo", rpm:"i386/debug/xorg-x11-xinit-debuginfo~1.0.2~16.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}