###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for vixie-cron FEDORA-2007-662
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861030);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2007-662");
  script_cve_id("");
  script_name( "Fedora Update for vixie-cron FEDORA-2007-662");
  desc = "

  Vulnerability Insight:
  The vixie-cron package contains the Vixie version of cron.  Cron is a
  standard UNIX daemon that runs specified programs at scheduled times.
  Vixie cron adds better security and more powerful configuration
  options to the standard version of cron.


  Affected Software/OS:
  vixie-cron on Fedora Core 6

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-August/msg00132.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of vixie-cron");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC6")
{

  if(isrpmvuln(pkg:"vixie-cron", rpm:"vixie-cron~4.1~69.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/vixie-cron", rpm:"x86_64/vixie-cron~4.1~69.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/debug/vixie-cron-debuginfo", rpm:"x86_64/debug/vixie-cron-debuginfo~4.1~69.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/vixie-cron", rpm:"i386/vixie-cron~4.1~69.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/debug/vixie-cron-debuginfo", rpm:"i386/debug/vixie-cron-debuginfo~4.1~69.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}