###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for rpm FEDORA-2007-668
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861575);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2007-668");
  script_cve_id("");
  script_name( "Fedora Update for rpm FEDORA-2007-668");
  desc = "

  Vulnerability Insight:
  The RPM Package Manager (RPM) is a powerful command line driven
  package management system capable of installing, uninstalling,
  verifying, querying, and updating software packages. Each software
  package consists of an archive of files along with information about
  the package like its version, a description, etc.


  Affected Software/OS:
  rpm on Fedora Core 6

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-August/msg00392.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of rpm");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC6")
{

  if(isrpmvuln(pkg:"rpm", rpm:"rpm~4.4.2.1~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/debug/rpm-debuginfo", rpm:"x86_64/debug/rpm-debuginfo~4.4.2.1~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/popt", rpm:"x86_64/popt~1.10.2.1~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/rpm-libs", rpm:"x86_64/rpm-libs~4.4.2.1~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/rpm-devel", rpm:"x86_64/rpm-devel~4.4.2.1~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/rpm-python", rpm:"x86_64/rpm-python~4.4.2.1~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/rpm", rpm:"x86_64/rpm~4.4.2.1~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/rpm-build", rpm:"x86_64/rpm-build~4.4.2.1~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/popt", rpm:"i386/popt~1.10.2.1~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/rpm-devel", rpm:"i386/rpm-devel~4.4.2.1~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/rpm-python", rpm:"i386/rpm-python~4.4.2.1~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/rpm-build", rpm:"i386/rpm-build~4.4.2.1~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/rpm", rpm:"i386/rpm~4.4.2.1~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/rpm-libs", rpm:"i386/rpm-libs~4.4.2.1~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/debug/rpm-debuginfo", rpm:"i386/debug/rpm-debuginfo~4.4.2.1~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}