###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for gd FEDORA-2007-692
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861279);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2007-692");
  script_cve_id("");
  script_name( "Fedora Update for gd FEDORA-2007-692");
  desc = "

  Vulnerability Insight:
  The gd graphics library allows your code to quickly draw images
  complete with lines, arcs, text, multiple colors, cut and paste from
  other images, and flood fills, and to write out the result as a PNG or
  JPEG file. This is particularly useful in Web applications, where PNG
  and JPEG are two of the formats accepted for inline images by most
  browsers. Note that gd is not a paint program


  Affected Software/OS:
  gd on Fedora Core 6

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-September/msg00311.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of gd");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC6")
{

  if(isrpmvuln(pkg:"gd", rpm:"gd~2.0.35~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/gd-progs", rpm:"x86_64/gd-progs~2.0.35~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/gd", rpm:"x86_64/gd~2.0.35~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/gd-devel", rpm:"x86_64/gd-devel~2.0.35~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/debug/gd-debuginfo", rpm:"x86_64/debug/gd-debuginfo~2.0.35~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/debug/gd-debuginfo", rpm:"i386/debug/gd-debuginfo~2.0.35~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/gd-progs", rpm:"i386/gd-progs~2.0.35~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/gd", rpm:"i386/gd~2.0.35~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/gd-devel", rpm:"i386/gd-devel~2.0.35~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}