###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for hplip FEDORA-2007-724
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861450);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2007-724");
  script_cve_id("CVE-2007-5208");
  script_name( "Fedora Update for hplip FEDORA-2007-724");
  desc = "

  Vulnerability Insight:
  The Hewlett-Packard Linux Imaging and Printing Project provides
  drivers for HP printers and multi-function peripherals.


  Affected Software/OS:
  hplip on Fedora Core 6

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-October/msg00217.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of hplip");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC6")
{

  if(isrpmvuln(pkg:"hplip", rpm:"hplip~1.7.4a~3.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/libsane-hpaio", rpm:"x86_64/libsane-hpaio~1.7.4a~3.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/hpijs", rpm:"x86_64/hpijs~1.7.4a~3.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/hplip", rpm:"x86_64/hplip~1.7.4a~3.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/debug/hplip-debuginfo", rpm:"x86_64/debug/hplip-debuginfo~1.7.4a~3.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/hplip", rpm:"i386/hplip~1.7.4a~3.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/debug/hplip-debuginfo", rpm:"i386/debug/hplip-debuginfo~1.7.4a~3.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/libsane-hpaio", rpm:"i386/libsane-hpaio~1.7.4a~3.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/hpijs", rpm:"i386/hpijs~1.7.4a~3.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}