###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for gtkmozembedmm FEDORA-2008-1535
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(860127);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2008-1535");
  script_cve_id("CVE-2008-0412", "CVE-2008-0413", "CVE-2008-0415", "CVE-2008-0419", "CVE-2008-0591", "CVE-2008-0593", "CVE-2008-0417", "CVE-2008-0418", "CVE-2008-0592", "CVE-2008-0414", "CVE-2008-0594");
  script_name( "Fedora Update for gtkmozembedmm FEDORA-2008-1535");
  desc = "

  Vulnerability Insight:
  This package provides a C++/gtkmm wrapper for GtkMozEmbed
  from Mozilla 1.4.x to 1.7.x.
  The wrapper provides a convenient interface for C++ programmers
  to use the Gtkmozembed HTML-rendering widget inside their software.


  Affected Software/OS:
  gtkmozembedmm on Fedora 8

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2008-February/msg00381.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of gtkmozembedmm");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC8")
{

  if(isrpmvuln(pkg:"gtkmozembedmm", rpm:"gtkmozembedmm~1.4.2.cvs20060817~18.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}