###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for sword FEDORA-2008-1922
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(860567);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2008-1922");
  script_cve_id("");
  script_name( "Fedora Update for sword FEDORA-2008-1922");
  desc = "

  Vulnerability Insight:
  The SWORD Project is the CrossWire Bible Society's free Bible software
  project. Its purpose is to create cross-platform open-source tools--
  covered by the GNU General Public License-- that allow programmers and
  Bible societies to write new Bible software more quickly and easily. We
  also create Bible study software for all readers, students, scholars,
  and translators of the Bible, and have a growing collection of over 200
  texts in over 50 languages.


  Affected Software/OS:
  sword on Fedora 7

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2008-February/msg00769.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of sword");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC7")
{

  if(isrpmvuln(pkg:"sword", rpm:"sword~1.5.10~2.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}