###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for viewvc FEDORA-2008-2143
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(860083);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2008-2143");
  script_cve_id("");
  script_name( "Fedora Update for viewvc FEDORA-2008-2143");
  desc = "

  Vulnerability Insight:
  ViewVC is a browser interface for CVS and Subversion version control
  repositories. It generates templatized HTML to present navigable directory,
  revision, and change log listings. It can display specific versions of files
  as well as diffs between those versions. Basically, ViewVC provides the bulk
  of the report-like functionality you expect out of your version control tool,
  but much more prettily than the average textual command-line program output.


  Affected Software/OS:
  viewvc on Fedora 7

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2008-March/msg00019.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of viewvc");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC7")
{

  if(isrpmvuln(pkg:"viewvc", rpm:"viewvc~1.0.5~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}