###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for bzip2 FEDORA-2008-3037
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(860532);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2008-3037");
  script_cve_id("CVE-2008-1372");
  script_name( "Fedora Update for bzip2 FEDORA-2008-3037");
  desc = "

  Vulnerability Insight:
  Bzip2 is a freely available, patent-free, high quality data compressor.
  Bzip2 compresses files to within 10 to 15 percent of the capabilities
  of the best techniques available.  However, bzip2 has the added benefit
  of being approximately two times faster at compression and six times
  faster at decompression than those techniques.  Bzip2 is not the
  fastest compression utility, but it does strike a balance between speed
  and compression capability.
  
  Install bzip2 if you need a compression utility.


  Affected Software/OS:
  bzip2 on Fedora 7

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2008-April/msg00225.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of bzip2");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC7")
{

  if(isrpmvuln(pkg:"bzip2", rpm:"bzip2~1.0.4~11.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}