###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for moin FEDORA-2008-3301
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(860260);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2008-3301");
  script_cve_id("CVE-2008-0780", "CVE-2008-0781", "CVE-2008-1099", "CVE-2008-1098");
  script_name( "Fedora Update for moin FEDORA-2008-3301");
  desc = "

  Vulnerability Insight:
  A WikiWikiWeb is a collaborative hypertext environment, with an emphasis on
  easy access to and modification of information. MoinMoin is a Python
  WikiClone that allows you to easily set up your own wiki, only requiring a
  Web server and a Python installation.


  Affected Software/OS:
  moin on Fedora 8

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2008-April/msg00510.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of moin");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC8")
{

  if(isrpmvuln(pkg:"moin", rpm:"moin~1.5.9~1.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}