###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for fetchmail FEDORA-2008-5800
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(860656);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2008-5800");
  script_cve_id("CVE-2008-2711");
  script_name( "Fedora Update for fetchmail FEDORA-2008-5800");
  desc = "

  Vulnerability Insight:
  Fetchmail is a remote mail retrieval and forwarding utility intended
  for use over on-demand TCP/IP links, like SLIP or PPP connections.
  Fetchmail supports every remote-mail protocol currently in use on the
  Internet (POP2, POP3, RPOP, APOP, KPOP, all IMAPs, ESMTP ETRN, IPv6,
  and IPSEC) for retrieval. Then Fetchmail forwards the mail through
  SMTP so you can read it through your favorite mail client.
  
  Install fetchmail if you need to retrieve mail over SLIP or PPP
  connections.


  Affected Software/OS:
  fetchmail on Fedora 8

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2008-June/msg01095.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of fetchmail");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC8")
{

  if(isrpmvuln(pkg:"fetchmail", rpm:"fetchmail~6.3.8~4.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}