###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for tomcat5 FEDORA-2008-8113
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(860209);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2008-8113");
  script_cve_id("CVE-2008-1232", "CVE-2008-1947", "CVE-2008-2370", "CVE-2008-2938");
  script_name( "Fedora Update for tomcat5 FEDORA-2008-8113");
  desc = "

  Vulnerability Insight:
  Tomcat is the servlet container that is used in the official Reference
  Implementation for the Java Servlet and JavaServer Pages technologies.
  The Java Servlet and JavaServer Pages specifications are developed by
  Sun under the Java Community Process.
  
  Tomcat is developed in an open and participatory environment and
  released under the Apache Software License. Tomcat is intended to be
  a collaboration of the best-of-breed developers from around the world.
  We invite you to participate in this open development project. To
  learn more about getting involved, click here.


  Affected Software/OS:
  tomcat5 on Fedora 9

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2008-September/msg00859.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of tomcat5");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC9")
{

  if(isrpmvuln(pkg:"tomcat5", rpm:"tomcat5~5.5.27~0jpp.2.fc9", rls:"FC9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}