###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for libtirpc FEDORA-2008-9204
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(860389);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2008-9204");
  script_cve_id("CVE-2008-4619");
  script_name( "Fedora Update for libtirpc FEDORA-2008-9204");
  desc = "

  Vulnerability Insight:
  This package contains SunLib's implementation of transport-independent
  RPC (TI-RPC) documentation.  This library forms a piece of the base of
  Open Network Computing (ONC), and is derived directly from the
  Solaris 2.3 source.
  
  TI-RPC is an enhanced version of TS-RPC that requires the UNIX System V
  Transport Layer Interface (TLI) or an equivalent X/Open Transport Interface
  (XTI).  TI-RPC is on-the-wire compatible with the TS-RPC, which is supported
  by almost 70 vendors on all major operating systems.  TS-RPC source code
  (RPCSRC 4.0) remains available from several internet sites.


  Affected Software/OS:
  libtirpc on Fedora 9

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2008-October/msg00819.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of libtirpc");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC9")
{

  if(isrpmvuln(pkg:"libtirpc", rpm:"libtirpc~0.1.7~20.fc9", rls:"FC9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}