###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for php-ZendFramework FEDORA-2010-0652
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861712);
  script_version("$Revision: 6862 $: 1.0");
  script_xref(name: "FEDORA", value: "2010-0652");
  script_name("Fedora Update for php-ZendFramework FEDORA-2010-0652");
  desc = "

  Vulnerability Insight:
  Extending the art &amp; spirit of PHP, Zend Framework is based on simplicity,
  object-oriented best practices, corporate friendly licensing, and a rigorously
  tested agile codebase. Zend Framework is focused on building more secure,
  reliable, and modern Web 2.0 applications &amp; web services, and consuming widely
  available APIs from leading vendors like Google, Amazon, Yahoo!, Flickr, as
  well as API providers and catalogers like StrikeIron and ProgrammableWeb.


  Affected Software/OS:
  php-ZendFramework on Fedora 12

  Fix: Please Install the Updated Packages.

  References:
  http://lists.fedoraproject.org/pipermail/package-announce/2010-January/034021.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of php-ZendFramework");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC12")
{

  if(isrpmvuln(pkg:"php-ZendFramework", rpm:"php-ZendFramework~1.9.7~1.fc12", rls:"FC12"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}