###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for chmsee FEDORA-2010-1936
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861665);
  script_version("$Revision: 6862 $: 1.0");
  script_xref(name: "FEDORA", value: "2010-1936");
  script_cve_id("CVE-2010-0159", "CVE-2010-0160", "CVE-2009-1571", "CVE-2009-3988", "CVE-2010-0162");
  script_name("Fedora Update for chmsee FEDORA-2010-1936");
  desc = "

  Vulnerability Insight:
  A gtk2 chm document viewer.
  
  It uses chmlib to extract files. It uses gecko to display pages. It supports
  displaying multilingual pages due to gecko. It features bookmarks and tabs.
  The tabs could be used to jump inside the chm file conveniently. Its UI is
  clean and handy, also is well localized. It is actively developed and
  maintained. The author of chmsee is Jungle Ji and several other great people.
  
  Hint
  * Unlike other chm viewers, chmsee extracts files from chm file, and then read
  and display them. The extracted files could be found in $HOME/.chmsee/bookshelf
  directory. You can clean those files at any time and there is a special config
  option for that.
  * The bookmark is related to each file so not all bookmarks will be loaded,
  only current file's.
  * Try to remove $HOME/.chmsee if you encounter any problem after an upgrade.


  Affected Software/OS:
  chmsee on Fedora 11

  Fix: Please Install the Updated Packages.

  References:
  http://lists.fedoraproject.org/pipermail/package-announce/2010-February/035349.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of chmsee");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC11")
{

  if(isrpmvuln(pkg:"chmsee", rpm:"chmsee~1.0.1~15.fc11", rls:"FC11"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}