###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for yelp FEDORA-2010-1936
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861692);
  script_version("$Revision: 6862 $: 1.0");
  script_xref(name: "FEDORA", value: "2010-1936");
  script_cve_id("CVE-2010-0159", "CVE-2010-0160", "CVE-2009-1571", "CVE-2009-3988", "CVE-2010-0162");
  script_name("Fedora Update for yelp FEDORA-2010-1936");
  desc = "

  Vulnerability Insight:
  Yelp is the help browser for the GNOME desktop. It is designed
  to help you browse all the documentation on your system in
  one central tool, including traditional man pages, info pages and
  documentation written in DocBook.


  Affected Software/OS:
  yelp on Fedora 11

  Fix: Please Install the Updated Packages.

  References:
  http://lists.fedoraproject.org/pipermail/package-announce/2010-February/035368.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of yelp");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC11")
{

  if(isrpmvuln(pkg:"yelp", rpm:"yelp~2.26.0~11.fc11", rls:"FC11"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}