###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for curl FEDORA-2010-2762
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861773);
  script_version("$Revision: 6957 $: 1.0");
  script_xref(name: "FEDORA", value: "2010-2762");
  script_name("Fedora Update for curl FEDORA-2010-2762");
  desc = "

  Vulnerability Insight:
  cURL is a tool for getting files from HTTP, FTP, FILE, LDAP, LDAPS,
  DICT, TELNET and TFTP servers, using any of the supported protocols.
  cURL is designed to work without user interaction or any kind of
  interactivity. cURL offers many useful capabilities, like proxy support,
  user authentication, FTP upload, HTTP post, and file transfer resume.


  Affected Software/OS:
  curl on Fedora 12

  Fix: Please Install the Updated Packages.

  References:
  http://lists.fedoraproject.org/pipermail/package-announce/2010-March/036744.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of curl");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC12")
{

  if(isrpmvuln(pkg:"curl", rpm:"curl~7.19.7~7.fc12", rls:"FC12"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}