###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for mingw32-libltdl FEDORA-2010-2943
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861670);
  script_version("$Revision: 6862 $: 1.0");
  script_xref(name: "FEDORA", value: "2010-2943");
  script_cve_id("CVE-2009-3736");
  script_name("Fedora Update for mingw32-libltdl FEDORA-2010-2943");
  desc = "

  Vulnerability Insight:
  The mingw32-libltdl package contains the GNU Libtool Dynamic Module Loader, a
  library that provides a consistent, portable interface which simplifies the
  process of using dynamic modules, for the mingw32 cross compilation
  environment.
  
  These runtime libraries are needed by programs that link directly to the
  system-installed ltdl libraries; they are not needed by software built using
  the rest of the GNU Autotools (including GNU Autoconf and GNU Automake).


  Affected Software/OS:
  mingw32-libltdl on Fedora 11

  Fix: Please Install the Updated Packages.

  References:
  http://lists.fedoraproject.org/pipermail/package-announce/2010-February/035851.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of mingw32-libltdl");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC11")
{

  if(isrpmvuln(pkg:"mingw32-libltdl", rpm:"mingw32-libltdl~1.5.26~17.fc11", rls:"FC11"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}