###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for argyllcms FEDORA-2010-3587
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861760);
  script_version("$Revision: 6917 $: 1.0");
  script_xref(name: "FEDORA", value: "2010-3587");
  script_name("Fedora Update for argyllcms FEDORA-2010-3587");
  desc = "

  Vulnerability Insight:
  The Argyll color management system supports accurate ICC profile creation for
  scanners, CMYK printers, film recorders and calibration and profiling of
  displays.
  
  Spectral sample data is supported, allowing a selection of illuminants observer
  types, and paper fluorescent whitener additive compensation. Profiles can also
  incorporate source specific gamut mappings for perceptual and saturation
  intents. Gamut mapping and profile linking uses the CIECAM02 appearance model,
  a unique gamut mapping algorithm, and a wide selection of rendering intents. It
  also includes code for the fastest portable 8 bit raster color conversion
  engine available anywhere, as well as support for fast, fully accurate 16 bit
  conversion. Device color gamuts can also be viewed and compared using a VRML
  viewer.


  Affected Software/OS:
  argyllcms on Fedora 12

  Fix: Please Install the Updated Packages.

  References:
  http://lists.fedoraproject.org/pipermail/package-announce/2010-March/036443.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of argyllcms");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC12")
{

  if(isrpmvuln(pkg:"argyllcms", rpm:"argyllcms~1.0.4~5.fc12", rls:"FC12"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}