###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_ffmpeg_mult_vuln_lin.nasl 7204 2010-02-11 18:09:24Z feb $
#
# FFmpeg Multiple Vulnerabilities (Linux)
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800468);
  script_version("$Revision: 6755 $: 1.0");
  script_cve_id("CVE-2009-4631", "CVE-2009-4632", "CVE-2009-4633", "CVE-2009-4634",
                "CVE-2009-4635", "CVE-2009-4636", "CVE-2009-4637", "CVE-2009-4638",
                "CVE-2009-4639", "CVE-2009-4640");
  script_name("FFmpeg multiple vulnerabilities (Linux)");
  desc = "
  Overview: This host is installed with FFmpeg and is prone to multiple
  vulnerabilities

  Vulnerability Insight:
  The multiple flaws are due to:
  - An out-of-bounds array index error in 'vorbis_dec.c'
  - An off-by-one indexing error in 'vp3.c'
  - Pointer arithmetic error in 'oggparsevorbis.c'
  - Assignment vs comparison operator mix-up error in 'vorbis_dec.c'
  - Integer underflow error leading to stack pointer wrap-around in 'vorbis_dec.c'
  - Integer underflow error in 'mov.c'
  - Type confusion error in 'mov.c'/'utils.c'

  Impact:
  Successful exploitation could result in Denial of Serivce condition(application
  crash or infinite loop) or possibly allow execution of arbitrary code.

  Impact Level: Application

  Affected Software/OS:
  FFmpeg version 0.5 on Linux.

  Fix: No solution/patch is available as on 11th February, 2010. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.ffmpeg.org/download.html

  Workaround:
  Apply workaround from below link,
  http://scarybeastsecurity.blogspot.com/2009/09/patching-ffmpeg-into-shape.html

  References:
  https://roundup.ffmpeg.org/roundup/ffmpeg/issue1240
  http://scarybeastsecurity.blogspot.com/2009/09/patching-ffmpeg-into-shape.html

  CVSS Score:
    CVSS Base Score      : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score  : 8.1
  Risk factor : Critical";

  script_description(desc);
  script_summary("Check for the version of FFmpeg");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("General");
  script_dependencies("gb_ffmpeg_detect_lin.nasl");
  script_require_keys("FFmpeg/Linux/Ver");
  exit(0);
}


include("version_func.inc");

ffmpegVer = get_kb_item("FFmpeg/Linux/Ver");
if(!ffmpegVer){
  exit(0);
}

# Grep for ffmpeg version 0.5
if(version_is_equal(version:ffmpegVer, test_version:"0.5")){
  security_hole(0);
}
