###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_filecopa_ftp_server_noop_dos_vuln.nasl 5291 2009-10-22 19:52:26Z oct $
#
# FileCopa FTP Server 'NOOP' Command DoS Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(801125);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-3662");
  script_bugtraq_id(36397);
  script_name("FileCopa FTP Server 'NOOP' Command DoS Vulnerability");
  desc = "
  Overview: This host is running FileCopa FTP Server and is prone to Denial of
  Service vulnerability.

  Vulnerability Insight:
  The flaw is caused due to an error in the handling of 'NOOP' FTP commands.
  This can be exploited to hang an affected server via an overly large number
  of specially crafted NOOP commands.

  Impact:
  Successful exploitation will let the attackers to cause a Denial of Service.

  Impact Level: Application

  Affected Software/OS:
  FileCopa FTP Server version 5.01 and prior on Windows.

  Fix: Upgrade to FileCopa FTP Server version 5.02
  http://www.filecopa-ftpserver.com/download.html

  References:
  http://secunia.com/advisories/36773
  http://downloads.securityfocus.com/vulnerabilities/exploits/36397.txt

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 3.9
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check the version of FileCopa FTP Server");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("FTP");
  script_dependencies("gb_filecopa_ftp_server_detect.nasl");
  script_require_keys("FileCOPA-FTP-Server/Ver");
  script_require_ports("Services/ftp", 21);
  exit(0);
}


include("ftp_func.inc");
include("version_func.inc");

filecopaPort = get_kb_item("Services/ftp");
if(!filecopaPort){
  exit(0);
}

filecopaVer = get_kb_item("FileCOPA-FTP-Server/Ver");
if(!filecopaVer){
  exit(0);
}

# Check for FileCopa FTP Server versions < 5.02
if(version_is_less(version:filecopaVer, test_version:"5.02")){
  security_warning(filecopaPort);
}
