###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_firebird_detect_win.nasl 3736 2009-08-06 21:45:24Z aug $
#
# Firebird SQL Version Detection (Win)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800851);
  script_version("$Revision: 1.0 $");
  script_name("Firebird SQL Version Detection (Win)");
  desc = "

  Overview: This script detects the installed version of Firebird SQL and
  sets the result in KB.

  Risk factor: Informational";

  script_description(desc);
  script_summary("Set version of Firebird SQL in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

if(!registry_key_exists(key:"SOFTWARE\Firebird Project\Firebird Server")){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";
foreach item (registry_enum_keys(key:key))
{
  # Check for Firebird DisplayName
  firebirdName = registry_get_sz(key:key + item, item:"DisplayName");
  if(firebirdName =~ "Firebird [0-9.]+")
  {
    # Check for Firebird DisplayVersion
    firebirdVer = registry_get_sz(key:key + item, item:"DisplayVersion");

    if(isnull(firebirdVer))
    {
      firePath = registry_get_sz(key:key + item, item:"DisplayIcon");
      share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:firePath);
      fire = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:firePath);

      # Check for Firebird .exe File Version
      firebirdVer = GetVer(file:fire, share:share);
    }

    # Set KB for Firebird
    if(!isnull(firebirdVer)){
      set_kb_item(name:"Firebird-SQL/Ver", value:firebirdVer);
    }
  }
}
