###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_firefox_bof_vuln_jul09_win.nasl 3538 2009-07-17 17:07:33Z jul $
#
# Mozilla Firefox Buffer Overflow Vulnerability - July09 (Win)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800846);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-2478", "CVE-2009-2479");
  script_bugtraq_id(35707);
  script_name("Mozilla Firefox Buffer Overflow Vulnerability - July09 (Win)");
  desc = "

  Overview: The host is installed with Mozilla Firefox browser and is prone
  to Buffer Overflow vulnerability.

  Vulnerability Insight:
  - A NULL pointer dereference error exists due an unspecified vectors, related
    to a 'flash bug.' which can cause application crash.
  - Stack-based buffer overflow error is caused by sending an overly long string
    argument to the 'document.write' method.

  Impact:
  Successful attacks will let attackers to can cause Denial of Service to the
  legitimate user.

  Impact Level: Application

  Affected Software/OS:
  Firefox version 3.5.1 and prior on Windows

  Fix: No solution or patch is available as on 17th July, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.mozilla.com/en-US/firefox/upgrade.html

  References:
  http://www.milw0rm.com/exploits/9158
  http://xforce.iss.net/xforce/xfdb/51729
  https://bugzilla.mozilla.org/show_bug.cgi?id=503286

  CVSS Score:
    CVSS Base Score     : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 9.0
  Risk factor: Critical";

  script_description(desc);
  script_summary("Check for the Version of Firefox");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Buffer overflow");
  script_dependencies("gb_firefox_detect_win.nasl");
  script_require_keys("Firefox/Win/Ver");
  exit(0);
}


include("version_func.inc");

ffVer = get_kb_item("Firefox/Win/Ver");
if(!ffVer){
  exit(0);
}

# Grep for Firefox version <= 3.5.1
if(version_is_less_equal(version:ffVer, test_version:"3.5.1")){
  security_hole(0);
}
