###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_firefox_mult_mem_crptn_vuln_nov09_lin.nasl 5567 2009-11-02 13:30:33Z nov $
#
# Mozilla Firefox Multiple Memory Corruption Vulnerabilities Nov-09 (Linux)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(801133);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-3371", "CVE-2009-3377", "CVE-2009-3378",
                "CVE-2009-3379", "CVE-2009-3381", "CVE-2009-3383");
  script_bugtraq_id(36854, 36872, 36873, 36875, 36870, 36869);
  script_name("Mozilla Firefox Multiple Memory Corruption Vulnerabilities Nov-09 (Linux)");
  desc = "
  Overview: This host is installed with Mozilla Firefox and is prone to multiple
  memory vorruption vulnerabilities.

  Vulnerability Insight:
  - An error exists when creating JavaScript web-workers recursively that can
    be exploited to trigger the use of freed memory.
  - An error in the embedded 'liboggz' or 'libvorbis' library that can be
    exploited to cause a crash.
  - An error exists in the 'oggplay_data_handle_theora_frame' function in
    media/liboggplay/src/liboggplay/oggplay_data.c in 'liboggplay' library that
    can be exploited to cause a crash.

  Impact:
  Successful exploitation will let attacker to cause Denial of Service or
  memory corrption on the user's system.

  Impact Level: Application/System

  Affected Software/OS:
  Firefox version 3.5 before 3.5.4 on Linux.

  Fix: Upgrade to Firefox version 3.5.4
  http://www.mozilla.com/en-US/firefox/all.html

  References:
  http://www.mozilla.org/security/announce/2009/mfsa2009-54.html
  http://www.mozilla.org/security/announce/2009/mfsa2009-63.html
  http://www.mozilla.org/security/announce/2009/mfsa2009-64.html

  CVSS Score:
    CVSS Base Score     : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.8
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Firefox");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("gb_firefox_detect_lin.nasl");
  script_require_keys("Firefox/Linux/Ver");
  exit(0);
}


include("version_func.inc");

ffVer = get_kb_item("Firefox/Linux/Ver");
if(!ffVer){
  exit(0);
}

# Check for Firefox version 3.5 < 3.5.4
if(version_in_range(version:ffVer, test_version:"3.5", test_version2:"3.5.3")) {
  security_hole(0);
}
