###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_firefox_mult_vuln_dec08_lin.nasl 725 2008-12-19 12:55:08Z dec $
#
# Mozilla Firefox Multiple Vulnerabilities December-08 (Linux)
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800089);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-5500", "CVE-2008-5501", "CVE-2008-5502", "CVE-2008-5503",
                "CVE-2008-5504", "CVE-2008-5505", "CVE-2008-5506", "CVE-2008-5507",
                "CVE-2008-5508", "CVE-2008-5510", "CVE-2008-5511", "CVE-2008-5512",
                "CVE-2008-5513");
  script_bugtraq_id(32882);
  script_name("Mozilla Firefox Multiple Vulnerabilities December-08 (Linux)");
  desc = "

  Overview: The host is installed with Mozilla Firefox browser and is prone
  to multiple vulnerabilities.

  Vulnerability:
  Refer to the reference links for more information on the vulnerabilities.

  Impact:
  Successful exploitation could result in remote arbitrary code execution,
  bypass security restrictions, sensitive information disclosure, cross
  site scripting attacks and execute JavaScript code with chrome privileges.

  Impact Level: System

  Affected Software/OS:
  Firefox version prior to 2.0.0.19 and 3.x to 3.0.4 on Linux.

  Fix: Upgrade to Firefox version 2.0.0.19 or 3.0.5
  http://www.mozilla.com/en-US/firefox/all.html

  References:
  http://www.mozilla.org/security/announce/2008/mfsa2008-60.html
  http://www.mozilla.org/security/announce/2008/mfsa2008-61.html
  http://www.mozilla.org/security/announce/2008/mfsa2008-62.html
  http://www.mozilla.org/security/announce/2008/mfsa2008-63.html
  http://www.mozilla.org/security/announce/2008/mfsa2008-64.html
  http://www.mozilla.org/security/announce/2008/mfsa2008-65.html
  http://www.mozilla.org/security/announce/2008/mfsa2008-66.html
  http://www.mozilla.org/security/announce/2008/mfsa2008-67.html
  http://www.mozilla.org/security/announce/2008/mfsa2008-68.html
  http://www.mozilla.org/security/announce/2008/mfsa2008-69.html

  CVSS Score:
    CVSS Base Score     : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.4
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Firefox");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("General");
  script_dependencies("gb_firefox_detect_lin.nasl");
  exit(0);
}


include("version_func.inc");

ffVer = get_kb_item("Firefox/Linux/Ver");
if(!ffVer){
  exit(0);
}

# Grep for firefox version < 2.0.0.19
if(version_is_less(version:ffVer, test_version:"2.0.0.19")){
  security_hole(0);
  exit(0);
}

# Grep for firefox version 3.x to 3.0.4
if(version_in_range(version:ffVer, test_version:"3.0", test_version2:"3.0.4")){
  security_hole(0);
}
