###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_firewall_builder_detect_lin.nasl 7550 2010-03-11 15:50:35Z mar $
#
# Firewall Builder Version Detection (Linux)
#
# Authors:
# Rachana Shetty <srachana@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800995);
  script_version("$Revision: 6992 $: 1.0");
  script_name("Firewall Builder Version Detection (Linux)");
  desc = "
  Overview : This script detects the installed version of Firewall Builder
  and sets the result in KB.

  Risk factor : Informational";

  script_description(desc);
  script_summary("Set version of Firewall Builder in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2010 Greenbone Networks GmbH");
  script_family("Service detection");
  script_dependencies("find_service.nes");
  exit(0);
}


include("ssh_func.inc");
include("version_func.inc");

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

paths = find_bin(prog_name:"fwbuilder", sock:sock);
foreach fwbuildbin (paths)
{
  fwbuildVer = get_bin_version(full_prog_name:chomp(fwbuildbin), sock:sock,
                              version_argv:"-v", ver_pattern:"([0-9.]+)");
  if(fwbuildVer[1] != NULL){
    set_kb_item(name:"FirewallBuilder/Linux/Ver", value:fwbuildVer[1]);
  }
}
ssh_close_connection();
