###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_fsecure_prdts_int_overflow_vuln_lin.nasl 995 2009-03-12 18:32:24Z mar $
#
# F-Secure Product(s) Integer Overflow Vulnerability (Linux)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800358);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-6085");
  script_bugtraq_id(31846);
  script_name("F-Secure Product(s) Integer Overflow Vulnerability (Linux)");
  desc = "

  Overview: This host is installed with F-Secure Product(s) and is prone to
  Integer Overflow vulnerability.

  Vulnerability Insight:
  The vulnerability is caused due to an integer overflow error while scanning
  contents of specially crafted RPM files inside the archives.

  Impact:
  Successful exploitation could allow remote attackers to craft the archive
  files with arbitrary codes and can cause integer overflow in the context
  of an affected application.

  Impact Level: System/Application

  Affected Software/OS:
  F-Secure Linux Security 7.01 and prior
  F-Secure Anti-Virus Linux Client/Server Security 5.54 and prior
  F-Secure Internet Gatekeeper for Linux 2.16 and prior on Linux.

  Fix: Apply patch,
  http://www.f-secure.com/security/fsc-2008-3.shtml

  References:
  http://secunia.com/advisories/32352
  http://securitytracker.com/alerts/2008/Oct/1021073.html

  CVSS Score:
    CVSS Base Score     : 7.6 (AV:N/AC:H/Au:NR/C:C/I:C/A:C) 
    CVSS Temporal Score : 5.6
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of F-Secure Products");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Buffer overflow");
  script_dependencies("gb_fsecure_prdts_detect_lin.nasl");
  script_require_keys("F-Sec/AV/LnxSec/Ver", "F-Sec/AV/LnxClntSec/Ver");
  script_require_keys("F-Sec/AV/LnxSerSec/Ver", "F-Sec/IntGatekeeper/Lnx/Ver");
  exit(0);
}


include("version_func.inc");

# Linux Security
fsavVer = get_kb_item("F-Sec/AV/LnxSec/Ver");
if(fsavVer != NULL)
{
  if(version_is_less(version:fsavVer, test_version:"7.02"))
  {
    security_hole(0);
    exit(0);
  }
}

# Client Security
fsavVer = get_kb_item("F-Sec/AV/LnxClntSec/Ver");
if(fsavVer != NULL)
{
  if(version_is_less(version:fsavVer, test_version:"5.54.7410"))
  {
    security_hole(0);
    exit(0);
  }
}

# Server Security
fsavVer = get_kb_item("F-Sec/AV/LnxSerSec/Ver");
if(fsavVer != NULL)
{
  if(version_is_less(version:fsavVer, test_version:"5.54.7410"))
  {
    security_hole(0);
    exit(0);
  }
}

# Internet Gatekeeper
fsigkVer = get_kb_item("F-Sec/IntGatekeeper/Lnx/Ver");
if(fsigkVer != NULL)
{
  if(version_is_less(version:fsigkVer, test_version:"2.16.580")){
    security_hole(0);
  }
}
