###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_fsecure_prdts_int_overflow_vuln_win.nasl 995 2009-03-12 19:32:24Z mar $
#
# F-Secure Product(s) Integer Overflow Vulnerability (Win)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800356);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-6085");
  script_bugtraq_id(31846);
  script_name("F-Secure Product(s) Integer Overflow Vulnerability (Win)");
  desc = "

  Overview: This host is installed with F-Secure Product(s) and is prone to
  Integer Overflow vulnerability.

  Vulnerability Insight:
  The vulnerability is caused due to an integer overflow error while scanning
  contents of specially crafted RPM files inside the archives.

  Impact:
  Successful exploitation could allow remote attackers to craft the archive
  files with arbitrary codes and can cause integer overflow in the context
  of an affected application.

  Impact Level: System/Application

  Affected Software/OS:
  F-Secure AntiVirus 2008 and prior
  F-Secure AntiVirus Workstation
  F-Secure Internet Security 2008 and prior
  F-Secure Client Security
  F-Secure Internet Gatekeeper for Windows 6.61 and prior

  Fix: Apply patch
  http://www.f-secure.com/security/fsc-2008-3.shtml

  References:
  http://secunia.com/advisories/32352
  http://securitytracker.com/alerts/2008/Oct/1021073.html

  CVSS Score:
    CVSS Base Score     : 7.6 (AV:N/AC:H/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 5.6
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of F-Secure Products");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Buffer overflow");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

if(!registry_key_exists(key:"SOFTWARE\Data Fellows\F-Secure")){
  exit(0);
}

# Get the path for F-Secure Anti-Virus, Client Security, Workstation
# and Internet Security
fsPath = registry_get_sz(key:"SOFTWARE\Data Fellows\F-Secure\Anti-Virus",
                         item:"Path");
if(!fsPath)
{
  # Get the path for Internet Gatekeeper and Anti-Virus for Microsoft Exchange
  fsPath = registry_get_sz(key:"SOFTWARE\Data Fellows\F-Secure" +
                               "\Content Scanner Server", item:"Path");
  if(!fsPath){
    exit(0);
  }
}

fsPath = fsPath + "\fm4av.dll";
share = ereg_replace(pattern:"([a-zA-Z]):.*", replace:"\1$", string:fsPath);
file = ereg_replace(pattern:"[a-zA-Z]:(.*)", replace:"\1", string:fsPath);

dllVer = GetVer(file:file, share:share);
if(!dllVer){
  exit(0);
}

# Grep for fm4av.dll version prior to 2.0.14340.7363
if(version_is_less(version:dllVer, test_version:"2.0.14340.7363")){
  security_hole(0);
}
