###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_ftpshell_server_bof_vuln.nasl 926 2009-02-05 13:20:29Z feb $
#
# FTPShell Server Buffer Overflow Vulnerability
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800226);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-0349");
  script_bugtraq_id(33403);
  script_name("FTPShell Server Buffer Overflow Vulnerability");
  desc = "

  Overview: This host is running FTPshell Server and is prone to Buffer
  Overflow Vulnerability.

  Vulnerability Insight:
  This flaw is due to a boundary error in the FTPShell server application
  when processing certain Windows registry keys.

  Impact:
  Successful exploitation will let the attacker craft a malicious license
  registry key file and can cause arbitrary code execution by tricking user
  to install the crafted malicious license registry file and may cause
  denial-of-service to the application.

  Affected Software/OS:
  FTPShell Server version 4.3.0 or prior on Windows.

  Fix: No solution or patch is available as on 05th February, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.ftpshell.com/server/index.htm

  References:
  http://secunia.com/advisories/33597
  http://www.milw0rm.com/exploits/7852

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 8.4
  Risk factor: Critical";

  script_description(desc);
  script_summary("Check for the version of FTPShell Server");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Buffer overflow");
  script_dependencies("find_service.nes", "gb_ftpshell_server_detect.nasl");
  script_require_keys("FTPShell/Version");
  script_require_ports("Services/ftp", 21);
  exit(0);
}

include("version_func.inc");

ftpPort = get_kb_item("Services/ftp");
if(!ftpPort){
  ftpPort = 21;
}

ftpShellVer = get_kb_item("FTPShell/Version");
if(!ftpShellVer){
  exit(0);
}

#Check for FTPShell Server version 4.3.0 or prior.
if(version_is_less_equal(version:ftpShellVer, test_version:"4.3.0")){
  security_hole(ftpPort);
}
